/***************************************************************/
//
//
//		DirectX	[Cube.cpp]
//
//												Author	kazuki tanaka
//												Date	2016 06/19
/*---------------------------------------------------------------
Update : 2016/06/19
		Cube.cpp쐬

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/
#include "main.h"
#include <math.h>
#include "cube.h"
#include "player.h"
#include "config.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/
/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/
#define CUBE_TEXTURENAME "data/TEXTURE/cube00.tga"

#define CUBE_RADIUS ( 100 )						//a

#define CUBE_POS_X (300)						//|S̕\ʒuX
#define CUBE_POS_Y (500)						//|S̕\ʒuY
#define CUBE_WIDTH (SCREEN_WIDTH)				//tB[h̕
#define CUBE_HEIGHT (550)						//tB[h̍
/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/
HRESULT MakeVertexCube(LPDIRECT3DDEVICE9 pDevice);
												//_̍쐬
void ColorCube ( VERTEX_2D *pVtx );				//

/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

LPDIRECT3DTEXTURE9 g_pTextureCube=nullptr;		//eNX`-C^[tF-Xp

LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferCube=nullptr;
												//_obt@C^[tF[Xւ̃|C^
VECTOR_2D g_cube;

float cubeX;
float cubeY;

// |S̏
void InitCube( void )
{

	LPDIRECT3DDEVICE9 lpD3DDevice=nullptr;		//foCX󂯎p֐

	// foCX̎󂯎
	lpD3DDevice = GetDevice( );

	// Wl
	cubeY = CUBE_POS_Y;

	// VERTEX_2D̐ݒ
	MakeVertexCube(lpD3DDevice);

	// eNX`̓ǂݍ
	if(FAILED(D3DXCreateTextureFromFile(lpD3DDevice,CUBE_TEXTURENAME,&g_pTextureCube)))
	{
		MessageBox(NULL,"eNX`̃t@C̓ǂݍ݂Ɏs܂","s", MB_YESNO | MB_ICONWARNING | MB_DEFBUTTON2);
	}

}
// |S̏I
void UninitCube( void ){

	// eNX`C^[tF[X̊J
	SAFE_RELEASE(g_pTextureCube)

	// _obt@C^[tF[X̊J
	SAFE_RELEASE(g_pVtxBufferCube)

}
// |S̍XV
void UpdateCube( void ){

	VECTOR_2D vec;		
	float r;			//a
	bool flag;			//ǂԂĂ炤

	//srand( (int) time(NULL));

	//rand();

	vec = GetPlayerPos( );

	r = sqrt( (float)(CUBE_POS_X*CUBE_POS_X) + (float)(CUBE_POS_Y*CUBE_POS_Y) );

	flag = CubeConfig( vec , CUBE_POS_X, CUBE_POS_Y , r );

	if( flag == true ){
		
		// ^Cgɖ߂
		ChangeMode( 0 );
		MessageBox(NULL,"^Cgɖ߂܂","GAME OVER", MB_YESNO | MB_ICONWARNING | MB_DEFBUTTON2);			//^CvMB_OK̎Ɠ

	}
	
}
// |S̕`
void DrawCube( void )
{

	LPDIRECT3DDEVICE9 lpD3DDevice=nullptr;			//foCX󂯎p֐


	// foCX̎󂯎菈
	lpD3DDevice=GetDevice( );

	// Xg[
	lpD3DDevice->SetStreamSource(0,					//MS
	g_pVtxBufferCube,								//ǂ̒_obt@\ƌԂ...
	0,												//f[^̃ItZbg
	sizeof(VERTEX_2D));								//XgChl(oCg)

	// _tH[}bg̐ݒ
	lpD3DDevice->SetFVF(FVF_VERTEX_2D);

	// eNX`̐ݒ
	lpD3DDevice->SetTexture(0,g_pTextureCube);		//_UVf[^Zbg
	
	// |S̕`
	lpD3DDevice->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,NUM_CUBE);


}
// _̍쐬
HRESULT MakeVertexCube( LPDIRECT3DDEVICE9 pDevice )
{

	VERTEX_2D *pVtx;									//zAhX

	if(FAILED(pDevice->CreateVertexBuffer(
			sizeof(VERTEX_2D) * NUM_VERTEX,				//mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,							//gp@
			FVF_VERTEX_2D,								//gp钸_tH[}bg(ȏȂQƂȂ̂0ł悢)
			D3DPOOL_MANAGED,							//obt@̊Ǘ@(obt@̒ɏ񂾂̂̊Ǘ@)
			&g_pVtxBufferCube,							//i[|C^
			NULL)))
	{

		MessageBox(NULL,"obt@ւ݂̏Ɏs܂!!","vertex buffer ERROR!!",MB_OK);
		return E_FAIL;
	}

	// obt@bNzAhX擾
	g_pVtxBufferCube -> Lock(0,0,(void**)&pVtx,0);		//GPUVRAMւ̑bN



	// _W̐ݒ

	pVtx[0].pos=D3DXVECTOR3( CUBE_POS_X-CUBE_RADIUS, CUBE_POS_Y-CUBE_RADIUS, 0.0f);
	pVtx[1].pos=D3DXVECTOR3( CUBE_POS_X+CUBE_RADIUS, CUBE_POS_Y-CUBE_RADIUS, 0.0f);
	pVtx[2].pos=D3DXVECTOR3( CUBE_POS_X-CUBE_RADIUS, CUBE_POS_Y+CUBE_RADIUS,0.0f);
	pVtx[3].pos=D3DXVECTOR3( CUBE_POS_X+CUBE_RADIUS, CUBE_POS_Y+CUBE_RADIUS,0.0f);

	pVtx[0].rhw=1.0f;
	pVtx[1].rhw=1.0f;
	pVtx[2].rhw=1.0f;
	pVtx[3].rhw=1.0f;

	pVtx[0].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[1].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[2].color=D3DCOLOR_RGBA(255,255,255,255);
	pVtx[3].color=D3DCOLOR_RGBA(255,255,255,255);

	pVtx[0].tex=D3DXVECTOR2( 0.0f, 0.0f );
	pVtx[1].tex=D3DXVECTOR2( 1.0f, 0.0f );
	pVtx[2].tex=D3DXVECTOR2( 0.0f, 1.0f );
	pVtx[3].tex=D3DXVECTOR2( 1.0f, 1.0f );

	// obt@̃AbN
	g_pVtxBufferCube->Unlock();

	return S_OK;

}
// W̎擾
float GetCubePos(void)
{

	return cubeY;

}
